%define module_name YAML-Safe
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel libyaml-devel perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(Filter/Util/Call.pm) perl(JSON/PP.pm) perl(LWP/Simple.pm) perl(Test/Deep.pm) perl(Text/Diff.pm) perl(YAML.pm) perl(YAML/XS.pm) perl(boolean.pm) perl(constant.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.82
Release: alt2
Summary: Safe Perl YAML Serialization using XS and libyaml
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RU/RURBAN/%{module_name}-%{version}.tar.gz

%description
This module is a refactoring of the YAML::XS manpage, the old Perl XS binding
to `libyaml' which offers Perl somewhat acceptable YAML support to
date.  YAML::XS never produced code which could be read from YAML, and
thus was unsuitable to be used as YAML replacement for core and CPAN.
It also required reading and setting options from global variables.

Kirill Siminov's `libyaml' is a YAML library implementation. The
C library is written precisely to the YAML 1.1 specification, and
offers YAML 1.2 support. It was originally bound to Python and was
later bound to Ruby.  `libsyck' is written a bit more elegant, has
less bugs, is not as strict as libyaml, but misses some YAML
features. It can only do YAML 1.0.

This module exports the functions `Dump' and `Load', and do work as
functions exactly like the YAML::XS manpage and `YAML.pm''s corresponding
functions.  It is however preferred to use the new OO-interface to
store all options in the new created object. YAML::Safe does not
support the old globals anymore.

There are also new Safe variants of Load and Dump methods, and
options as setter methods.
With the Safe methods you can enforce loading YAML 1.0 files only,
all unsafe tags are removed. By default all blessed data is unsafe.

If you set the option `noindentmap', `YAML::Safe' will behave like
with version < 0.70, which creates yml files which cannot be read
by `YAML.pm'

However the loader is stricter than `YAML', `YAML::Syck' and
`CPAN::Meta::YAML' i.e. `YAML::Tiny' as used in core. Set the option
`nonstrict' to allow certain reader errors to pass the
`CPAN::Meta' validation testsuite.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/Y*
%perl_vendor_autolib/*

%changelog
