# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name YAX
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Yet Another XML Library
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RH/RHUNDT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
YAX is a fast pure Perl XML library for easily parsing, constructing,
querying and manipulating XML. Simple benchmarks have shown that it is
substantially faster than the XML::DOM::Parser manpage which uses Expat internally
(which is written in C), see the PERFORMANCE entry elsewhere in this document for an explanation and
related caveats.

However, the main point of YAX is to remove the verbosity of the DOM API
by using more perlish tricks such as operator overloading. For example,
element nodes can behave as both array references and hash references. If
dereferenced as an array reference, then a list of children is returned;
as a hash reference, the attributes hash is returned. So the following
show uses cases for this:

 my @good_books = grep { $_->{author} =~ /\bAsimov\b/ } @$elmt;

You can also hang out of band data onto your elements:

 $elmt->{notes} = IO::File->new( './notes/asimov.txt' );

without affecting serialization since attributes who's values are
references are ignored during stringification.

YAX nodes, of course, also provide methods for appending, replacing
and removing children as well (note the following all operate on
the children of `$node'):

 $node->replace( $new_child, $ref_child );
 $node->remove( $child );
 $node->append( $child );
 $node->insert( $new_child, $ref_child );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/Y*

%changelog
