%define module_name Zabbix-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/Exception.pm) perl(Test/LWP/UserAgent.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: A small module to eliminate boilerplate overhead when using the Zabbix API
Group: Development/Perl
License: perl
URL: https://github.com/whosgonna/Zabbix-Tiny.pm

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WH/WHOSGONNA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module functions as a simple wrapper to eliminate boilerplate that might otherwise need to be created when interfacing with the Zabbix API.  Login to the Zabbix server is handled with the constructor. Beyond that, the primary method is the `do' method. The user.logout method is implemented  in the object deconstructor as well, so there should be no need to explicity logout of Zabbix.

This module was developed against Zabbix 2.4, and is expected to work with Zabbix 2.2, and likely 2.0 as well.  It is much less certain it will work with Zabbix 1.8.  Please refer to the API section of the Zabbix manual for details on its methods.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md examples
%perl_vendor_privlib/Z*

%changelog
