# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Class/Accessor/Fast.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec/Functions.pm) perl(File/Which.pm) perl(HTML/Entities/Numbered.pm) perl(HTTP/Tiny.pm) perl(Mac/PropertyList.pm) perl(Mac/PropertyList/SAX.pm) perl(Object/MultiType.pm) perl(Test/Perl/Critic.pm) perl(XML/Entities.pm) perl(XML/Rules.pm) perl(XML/SAX/Expat.pm) perl(XML/SAX/ParserFactory.pm) perl(enum.pm) perl(parent.pm) perl(re.pm)
# END SourceDeps(oneline)
%define module_name Zeal
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001001
Release: alt1
Summary: Read and query Dash/Zeal docsets
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Dash is an offline API documentation browser. Zeal.pm is a module for
reading and querying Dash documentation sets.

This module queries multiple docsets. If you only have one docset, you
should use the the Zeal::Docset manpage module directly.

Available methods:

=over

=item Zeal->new([*$path*])

Create a new Zeal object. *$path* is an optional colon delimited
string for initializing the object. Each of its components is
recursively scanned for docsets (and can also be a docset itself). If
*$path* is not provided, the value of *$ENV{ZEAL_PATH}* (if defined)
is used instead.

=item $zeal->add(*$path*)

Recursively scan a path for docsets, adding them to this object.

=item $zeal->sets([*$family*])

Return a list of docsets (the Zeal::Docset manpage objects) in the given
family, or in all families if *$family* is not provided.

=item $zeal->query(*"$family:$query"*)

=item $zeal->query(*$query*, [*$family*])

Return a list of documents (the Zeal::Document manpage objects) matching a
query, optionally restricted to a family. In scalar context only one
such document is returned. *$query* is a SQL LIKE condition.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/Z*

%changelog
