%define module_version 0.005
%define module_name authority
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Object/AUTHORITY.pm) perl(Test/More.pm) perl(UNIVERSAL/AUTHORITY/Lexical.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: loads a module only if it has a particular authority
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/authority

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This pragma allows you to indicate that you wish to load a module only
if its authority is a particular URI.

Using this pragma automatically enables the UNIVERSAL::AUTHORITY manpage.

=over

=item `use authority $authority, $module, @arguments'

Require and import the module at compile time. This is the usual mode
of operation.

=item `authority->import($authority, $module, @arguments)'

Require and import the module at run time. 

=back

Note that the special `$authority' value "Any", indicates that any
authority is allowed (including undef).

Experimentally, `$module' may contain a module name and minimum version,
separated with a space.

There is also a very experimental feature allowing releases of the
same package by different authorities to live side-by-side, though
only one of them can be required into a running script.

In this case, assuming that the inc path is `/opt/perl/lib' and a
script does this:

 use authority 'cpan:JOE', My::Module => qw();

Then Perl will attempt to load `/opt/perl/lib/cpan_3A_JOE/My/Module.pm'
before it tries the usual `/opt/perl/lib/My/Module.pm'.

This is not anywhere near as powerful as the authority feature of Perl 6,
but it's a start.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE COPYRIGHT examples
%perl_vendor_privlib/a*

%changelog
