Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-bareword-filehandles
Version:        0.007
Release:        alt5_17
Summary:        Disables bareword filehandles
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/bareword-filehandles
Source0:        https://cpan.metacpan.org/authors/id/I/IL/ILMARI/bareword-filehandles-%{version}.tar.gz
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
# B::Hooks::OP::Check is examined by ExtUtils::Depends from Makefile.PL
BuildRequires:  perl(B/Hooks/OP/Check.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/Depends.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(if.pm)
# Lexical::SealRequireHints not used on Perl >= 5.12
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Test/More.pm)


Source44: import.info

%description
This module lexically disables the use of bareword filehandles with built-in
functions, except for the special built-in filehandles STDIN, STDOUT,
STDERR, ARGV, ARGVOUT and DATA.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n bareword-filehandles-%{version}
# Fix shebangs
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="%{optflags}"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/bareword*

%files tests
%{_libexecdir}/%{name}

%changelog
