# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(Date/Calc.pm) perl(Date/Manip.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Finance/YahooQuote.pm) perl(HTML/FormatText.pm) perl(HTML/TreeBuilder.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Statistics/Descriptive.pm) perl(Text/ParseWords.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_version 0.8.10
%define module_name beancounter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8.10
Release: alt1
Summary: Module for stock portfolio performance functions.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/ED/EDD/%{module_name}_%{module_version}.tar.gz
BuildArch: noarch

%description
Finance::BeanCounter provides functions to *download*, *store* and
*analyse* stock market data.

*Downloads* are available of current (or rather: 15 or 20
minute-delayed) price and company data as well as of historical price
data.  Both forms can be stored in an SQL database (for which we
currently default to PostgreSQL though MySQL is supported as
well; furthermore any database reachable by means of an ODBC
connection should work).

*Analysis* currently consists of performance and risk
analysis. Performance reports comprise a profit-and-loss (or 'p/l' in
the lingo) report which can be run over arbitrary time intervals such
as `--prevdate 'friday six months ago' --date 'yesterday'' -- in
essence, whatever the wonderful Date::Manip module understands --
as well as dayendreport which defaults to changes in the last trading
day. A risk report show parametric and non-parametric value-at-risk
(VaR) estimates.

Most available functionality is also provided in the reference
implementation beancounter, a convenient command-line script.

The API might change and evolve over time. The low version number
really means to say that the code is not in its final form yet, but it
has been in use for well over four years.

More documentation is in the Perl source code.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.non-gnu TODO README.Debian README
%perl_vendor_privlib/F*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
