Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Filter the Perl extension module


Summary:        Perl module for context-sensitive phonetic string replacement
Name:           perl-ccom
Version:        1.4.1
Release:        alt13_47
License:        LGPLv2+
URL:            https://www.heise.de/ct/ftp/99/25/252/
Source0:        ftp://ftp.heise.de/pub/ct/listings/phonet.tgz
Patch0:         perl-ccom-1.4.1-format-security.patch
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
Source44: import.info

%description
A perl module for context-sensitive phonetic string replacement to modify
strings according to predefined replacement rules in such a way that words
with the same pronunciation (e.g. "tail" and "tale") are converted to the
same string. This can, for example, be used to implement error-tolerant
search routines in address databases. It contains phonetic rules for German
only, but the software has been prepared for multi-language support.
                                                                                                        
%prep
%setup -q -c -n %{name}
%patch0 -p0 -b .format-security

# Clean the strange packaging first
mv -f ccom*/* .
chmod 644 *.xs ccomlib/*

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%make_build

# Change man page encoding into UTF-8

%install
%makeinstall_std
%if 0%{?rhel} && 0%{?rhel} <= 7
find $RPM_BUILD_ROOT \( -name perllocal.pod -o -name .packlist \) -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name '*.bs' -empty -exec rm -f {} ';'
%endif
chmod -R u+w $RPM_BUILD_ROOT/*

# Fix incorrect permissions
chmod 644 Changes readme_perl.txt ccom_test.pl

# Fix incorrect end-of-line encoding
sed -e 's/\r//' -i copying.lib -i readme_perl.txt

# Fix incorrect interpreter path
sed -e 's@#! /opt/perl5/bin/perl@#!%{_bindir}/perl@' -i ccom_test.pl

# Remove test/example from regulars
rm -f $RPM_BUILD_ROOT%{perl_vendor_archlib}/ccom_test.pl

%files
%doc --no-dereference copying.lib
%doc Changes readme_perl.txt ccom_test.pl
%{perl_vendor_archlib}/*.pm
%{perl_vendor_archlib}/auto/ccom
%{perl_vendor_archlib}/*.pm

%changelog
