# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Archive/Tar.pm) perl(Archive/Zip.pm) perl(Class/Singleton.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Iterator.pm) perl(File/Find/Rule.pm) perl(File/HomeDir.pm) perl(File/MMagic.pm) perl(File/Temp.pm) perl(File/Type.pm) perl(File/chdir.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(HTML/Entities.pm) perl(HTML/Parser.pm) perl(HTTP/Date.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(IO/String.pm) perl(Image/ExifTool.pm) perl(Iterator/Simple.pm) perl(LWP.pm) perl(LWP/Debug.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Locale/TextDomain.pm) perl(Module/Load.pm) perl(Module/Util.pm) perl(Net/Config.pm) perl(Net/NNTP.pm) perl(POSIX.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Policy/Compatibility/PodMinimumVersion.pm)
BuildRequires(pre): perl(Perl/Critic/Utils.pm) perl(Perl6/Slurp.pm) perl(Pod/ParseLink.pm) perl(Pod/Parser.pm) perl(Pod/Simple/HTML.pm) perl(Regexp/Common.pm) perl(Regexp/Common/URI/RFC2396.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test/More.pm) perl(Text/Tabs.pm) perl(Tie/Array.pm) perl(Time/Local.pm) perl(URI.pm) perl(URI/Escape.pm) perl(URI/Find.pm) perl(URI/file.pm) perl(WWW/Mechanize.pm) perl(YAML.pm) perl(base.pm) perl(constant/defer.pm)
# END SourceDeps(oneline)
%define module_version 11
%define module_name distlinks
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 11
Release: alt1
Summary: URL link checking with database.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/distlinks/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Distlinks checks URLs found in files or a directory tree of files.  An
SQLite-3 database avoids rechecking links between multiple program runs.
It's a bit rough but good for checking everything in a software distribution
or similar.

Various file types are recognised and read appropriately to extract text
parts to find URLs.

=over

=item *

.gz and .bz2 gzip or bzip2.

=item *

.tar and .tar.gz Unix tar.

=item *

.zip

=item *

Text with UTF-16 or UTF-32 byte-order marker.

=item *

Image files per `Image::ExifTool', so the text parts of PNG, JPEG, etc.

=item *

.mo message catalogue per `gettext' (recognised by content, so any
filename).

=item *

Skip executables ELF, MS-DOS, etc as identified by `File::Type'.

=back

URLs are distilled from text with free-form matching so they can be in plain
text, program code, etc.  The following specific forms are recognised,

=over

=item *

Angles `<http://foo.com>' and `<URL:http://foo.com>' as sometimes
recommended for mail messages etc.

=item *

Quotes ``http://foo.com'' per Emacs docstrings.

=item *

Bare `foo.com/index.html' taken to be `http:'.

=item *

Texinfo `@url{http://foo.com}'.

=item *

HTML `href="foo.html"', interpreted relative to a `<base>' or the file
itself.

=item *

Skip variables `$FOO' in URLs, taken to be program code etc.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
