Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname perl-eperl
Name:           perl-eperl
Version:        2.2.14
Release:        alt12_52
Summary:        Embedded Perl Language
License:        GPL+ or Artistic
URL:            http://www.ossp.org/pkg/tool/eperl/
Source0:        ftp://ftp.ossp.org/pkg/tool/eperl/eperl-%{version}.tar.gz
Patch0:         http://ftp.debian.org/pool/main/e/eperl/eperl_2.2.14-15.1.diff.gz
Patch1:         perl-eperl-5.16compat.patch
# Fix format-security compiler warnings, bug #1058664
Patch2:         eperl-2.2.14-Fix-format-security-compiler-warnings.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  libgdbm-devel
BuildRequires:  gcc
BuildRequires:  libdb4.8-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/Embed.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
Source44: import.info

%description
ePerl interprets an ASCII file bristled with Perl 5 program statements
by evaluating the Perl 5 code while passing through the plain ASCII
data. It can operate in various ways: As a stand-alone Unix filter or
integrated Perl 5 module for general file generation tasks and as a
powerful Webserver scripting language for dynamic HTML page
programming.

The documentation and latest release can be found on
http://www.ossp.org/pkg/tool/eperl/

Note that this package does not include the Apache::ePerl module,
which is designed for mod_perl 1.x.

%prep
%setup -q -n eperl-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
chmod u+x etc/shtool
find contrib/utils -perm /0100 -type f -exec chmod 644 {} \;

%build
# Use NO_PERLLOCAL to stop generating perllocal.pod
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS" \
    NO_PACKLIST=1 NO_PERLLOCAL=1
#perl -pi -e 's/^\tLD_RUN_PATH=[^\s]+\s*/\t/' Makefile
%{make_build}
make -f Makefile.stand %{?_smp_mflags} eperl \
    prefix=%{_prefix} libdir=%{_datadir}/eperl

%install
# pure_install doesn't work.
%{makeinstall_std}
make -f Makefile.stand install \
    prefix=$RPM_BUILD_ROOT%{_prefix} libdir=$RPM_BUILD_ROOT%{_datadir}/eperl

# Remove all of the Apache bits.
find $RPM_BUILD_ROOT -iname '*apache*' -exec rm -rf {} \; || :
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference ARTISTIC COPYING
%doc ANNOUNCE ChangeLog ChangeLog.1x ChangeLog.20 ChangeLog.21
%doc INSTALL.APACHE INSTALL.NSAPI KNOWN.BUGS NEWS README
%doc eperl_logo.gif eperl_powered.gif contrib/utils/
%{perl_vendor_archlib}/*
%{_bindir}/eperl
%{_datadir}/eperl
%{_mandir}/man1/*

%changelog
