%def_without test
%define module_version 1.21
%define module_name iCal-Parser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/ICal.pm) perl(DateTime/Span.pm) perl(DateTime/TimeZone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(FreezeThaw.pm) perl(IO/File.pm) perl(IO/String.pm) perl(Test/More.pm) perl(Text/vFile/asData.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.21
Release: alt1
Summary: Parse iCalendar files into a data structure
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RI/RIXED/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module processes iCalendar (vCalendar 2.0) files as specified in RFC 2445
into a data structure.
It handles recurrences (`RRULE's), exclusions (`EXDATE's), event updates
(events with a `RECURRENCE-ID'), and nested data structures (`ATTENDEES' and
`VALARM's). It currently ignores the `VTIMEZONE', `VJOURNAL' and
`VFREEBUSY' entry types.

The data structure returned is a hash like the following:

    {
      calendars=>[\%%cal, ...],
      events=>{yyyy=>{mm=>{dd}=>{UID=>\%%event}}
      todos=>[\%%todo, ...]
    }

That is, it contains an array of calendar hashes, a hash of events key by
`year=>month=>day=>eventUID', and an array of todos.

Calendars, events and todos are "rolled up" version os the hashes returned from
the Text::vFile::asData manpage, with dates replaced by `DateTime' objects.

During parsing, events in the input calendar are expanded out into multiple
events, one per day covered by the event, as follows:

=over 4

=item *

If the event is a one day "all day" event (in ical, the event is 24hrs long,
starts at midnight on the day and ends a midnight of the next day),
it contains no `hour' field and the `allday' field is set to `1'.

=item *

If the event is a recurrence (`RRULE'), one event per day is created as
per the `RRULE' specification.

=item *

If the event spans more than one day (the start and end dates are on different
days, but does not contain an `RRULE'),
it is expanded into multiple events, the first events end time is set
to midnight, subsequent events are set to start at midnight and end at
midnight the following day (same as an "allday" event, but the `allday' field
is not set), and the last days event is set to run from midnight to the
end time of the original multi-day event.

=item *

If the event is an update (it contains a `RECURRENCE-ID'), the original
event is updated. If the referenced event does not exist (e.g., it was
deleted after the update), then the event is added as a new event.

=back


An example of each hash is below.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE ChangeLog
%perl_vendor_privlib/i*

%changelog
