%define module_name khatgallery
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/stat.pm) perl(Getopt/ArgvFile.pm) perl(Getopt/Long.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Image/ExifTool.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Test/CPAN/Meta.pm) perl(Test/Distribution.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(YAML.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2405
Release: alt1
Summary: HTML photo album generator.
Group: Development/Perl
License: perl
URL: https://github.com/rubykat/khatgallery

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RU/RUBYKAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HTML::KhatGallery generates a HTML photo gallery.  It takes a directory.of images, and generates the HTML pages and thumbnails needed.

This includes the khatgallery script (to generate the gallery)
and the kg_image_info script (to get information about an image).

I decided to write this because, while there are gazillion gallery scripts
out there, none of them do quite what I want, and I wanted to take nice
features from different scripts and bring them together.

=over

=item *

Pre-generated (baked, not fried)

=item *

Can recurse down into sub-directories of the top gallery directory.

=item *

Generates only new files by default.

=item *

Can clean out unused files.

=item *

Can force regeneration of HTML or thumbnails.

=item *

Does not require Javascript.

=item *

Ability to add plugins.

=item *

Meta-data from more than just jpeg files.

=item *

Multi-page albums.  That is, directories with lots of images can show
only so many images per index page, instead of having to load every
single thumbnail.

=item *

Very simple page template, not complicated themes.

=item *

Pixel-area thumbnails (rather than conforming to particular width or
height, you get higher-quality thumbnails by making them have a given
area).

=item *

XHTML compliant.

=item *

Dynamic columns with CSS and HTML, rather than fixed tables.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README.mkdn README Changes
%perl_vendor_privlib/H*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
