%define module_name lexical-underscore
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(if.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: access your caller's lexical underscore
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/lexical-underscore

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Starting with Perl 5.10, it is possible to create a lexical version of the Perl.default variable `$_'. Certain Perl constructs like the `given' keyword
automatically use a lexical `$_' rather than the global `$_'.

It is occasionallly useful for a sub to be able to access its caller's
`$_' variable regardless of whether it was lexical or not. The `(_)'
sub prototype is the official way to do so, however there are sometimes
disadvantages to this; in particular it can only appear as the final required
argument in a prototype, and there is no way of the sub differentiating between
an explicitly passed argument and `$_'.

This caused me problems with the Scalar::Does manpage, because I wanted to enable the
`does' function to be called as either:

   does($thing, $role);
   does($role);  # assumes $thing = $_

With `_' in the prototype, `$_' was passed to the function at the end
of its argument list; effectively `does($role, $thing)', making it
impossible to tell which argument was the role.

Enter `lexical::underscore' which allows you to access your caller's lexical
`$_' variable as easily as:

   ${lexical::underscore()}

You can access lexical `$_' further up the call stack using:

   ${lexical::underscore($level)}

If you happen to ask for `$_' at a level where no lexical `$_' is
available, you get the global `$_' instead.

This module does work on Perl 5.8 but as there is no lexical `$_', always
returns the global `$_'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CREDITS Changes COPYRIGHT README LICENSE
%perl_vendor_privlib/l*

%changelog
