%define module_name lib-noop
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Installed/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: no-op loading some modules
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/lib-noop

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
SYNOPSIS

     use lib::noop qw(Foo::Bar Baz);
     use Foo::Bar; # now a no-op
     use Qux; # load as usual

DESCRIPTION

    Given a list of module names, it will make subsequent loading of those
    modules a no-op. It works by installing a require hook in @INC that
    looks for the specified modules to be no-op'ed and return "1;" as the
    source code for those modules.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/l*

%changelog
