# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(B.pm) perl(Benchmark.pm) perl(CPAN.pm) perl(Fatal.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/stat.pm) perl(FindBin.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(warnings/register.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    macro
%define upstream_version 0.06

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Macro.pm compiler backend
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Filter/Util/Call.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(PPI.pm)
BuildRequires: perl(Test/Warn.pm)
BuildArch: noarch
Source44: import.info

%description
The 'macro' pragma provides macros, a sort of inline functions, which is
like C pre-processor's macro.

The macros are very fast (about 200% faster than subroutines), but they
have some limitations that C pre-processor's macros have, e.g. they cannot
call 'return()' expectedly, although they seem anonymous subroutines.

Try 'PERL_MACRO_DEBUG=2' if you want to know how this module works.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
