%define module_name mb-Encode
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(FindBin.pm) perl(Jacode.pm) perl(Socket.pm) perl(Test.pm) perl(lib.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: provides MBCS encoder and decoder
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INA/mb/Encode/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use mb::Encode qw();
 
    # MBCS encode
    $big5_octet      = mb::Encode::to_big5     (UTF8_octet);
    $big5hkscs_octet = mb::Encode::to_big5hkscs(UTF8_octet);
    $cp932_octet     = mb::Encode::to_cp932    (UTF8_octet);
    $cp936_octet     = mb::Encode::to_cp936    (UTF8_octet);
    $cp949_octet     = mb::Encode::to_cp949    (UTF8_octet);
    $cp950_octet     = mb::Encode::to_cp950    (UTF8_octet);
    $eucjp_octet     = mb::Encode::to_eucjp    (UTF8_octet);
    $gbk_octet       = mb::Encode::to_gbk      (UTF8_octet);
    $sjis_octet      = mb::Encode::to_sjis     (UTF8_octet);
    $uhc_octet       = mb::Encode::to_uhc      (UTF8_octet);
 
    # MBCS decode
    $UTF8_octet = mb::Encode::by_big5     (big5_octet     );
    $UTF8_octet = mb::Encode::by_big5hkscs(big5hkscs_octet);
    $UTF8_octet = mb::Encode::by_cp932    (cp932_octet    );
    $UTF8_octet = mb::Encode::by_cp936    (cp936_octet    );
    $UTF8_octet = mb::Encode::by_cp949    (cp949_octet    );
    $UTF8_octet = mb::Encode::by_cp950    (cp950_octet    );
    $UTF8_octet = mb::Encode::by_eucjp    (eucjp_octet    );
    $UTF8_octet = mb::Encode::by_gbk      (gbk_octet      );
    $UTF8_octet = mb::Encode::by_sjis     (sjis_octet     );
    $UTF8_octet = mb::Encode::by_uhc      (uhc_octet      );
 
    # imports short name
    use mb::Encode qw(
        to_big5       big5       by_big5
        to_big5hkscs  big5hkscs  by_big5hkscs
        to_cp932      cp932      by_cp932
        to_cp936      cp936      by_cp936
        to_cp949      cp949      by_cp949
        to_cp950      cp950      by_cp950
        to_eucjp      eucjp      by_eucjp
        to_gbk        gbk        by_gbk
        to_sjis       sjis       by_sjis
        to_uhc        uhc        by_uhc
    );
 
    # MBCS encode on shorthand
    $big5_octet      = big5     (UTF8_octet);
    $big5hkscs_octet = big5hkscs(UTF8_octet);
    $cp932_octet     = cp932    (UTF8_octet);
    $cp936_octet     = cp936    (UTF8_octet);
    $cp949_octet     = cp949    (UTF8_octet);
    $cp950_octet     ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes CONTRIBUTING LICENSE
%perl_vendor_privlib/m*

%changelog
