%define module_name mro-EVERY
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Symbol.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.3
Release: alt1
Summary: EVERY & EVERY::LAST pseudo-packages using mro.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEMBARK/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
The main use of both pseudo-classes is re-dispatching an arbitrary 
method up or down the inheritence stack without each class in the
hierarchy having to do its own re-dispatch to another. One common
use of this is in initializers, which can use EVERY::LAST to walk
the tree from least-to-most derived classes calling the method where
it is declared in each class (vs. simply inherited). This works 
nicely for base class destructors also using EVERY to tear down the
object from most-to-least derived layers. 

An initial sanity check of '$object->can( $method )' to ensure that
something in the hierarchy claims to handle the call. If not an 
exception is raised. Inherited methods are also skipped to avoid
duplicate dispatches into the same method with the same object. 
For installed methods a unique check for the returned coderefs 
also helps avoid duplicate dispatches. 

Without autoloading this is quite simple: Walk down the list from
mro::get_linear_isa looking for packages that define their own code
for the method name. The resulting list of subrefs is dispatced in
order for EVERY and in reverse for EVERY::LAST. This is pretty much
the same guts as NEXT, just using mro for the package names rather
than iterating on @ISA. 

Autoload requires a bit more work, and co-operation from the classes
in overloading can() to return true for methods handled by the 
AUTOLOAD. In some cases it's trivial: return true for anything.
If the AUTOLOAD only handles some cases then can() needs to return
the correct ones. The AUTOLOAD also has to exist in the classes
package space (vs. being inherited).

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/m*

%changelog
