# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/EndOfScope.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(IO/Handle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(autodie.pm) perl(if.pm) perl(inc/Module/Install.pm) perl(indirect.pm) perl(mro.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name nextgen
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt2
Summary: enable all of the features of next-generation perl 5 with one command
Group: Development/Perl
License: perl
URL: http://github.com/EvanCarroll/nextgen

Source0: http://cpan.org.ua/authors/id/E/EC/ECARROLL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The nextgen pragma uses several modules to enable additional features of Perl
and of the CPAN.  Instead of copying and pasting all of these `use' lines,
instead write only one:

    use nextgen;


But the joy doens't stop there, here are some examples of the command line.

    perl -Mnextgen -E'say Class->new->meta->name'
    
    # You can see warnings is on:
    perl -Mnextgen -E'(undef) + 5'
    
    # And, strict
    perl -Mnextgen -E'my $foo = "bar"; $$foo = 4; say $$foo'
    
    #	And, it wouldn't be nextgen if this was allowed.	
    perl -Mnextgen -E'use NEXT;'
    
    # Or, this
    perl -Mnextgen -MNEXT -e1

But the joy doesn't stop there, here are some examples in module.

    package Foo;
    ## easier than strict, warnings, indirect, autodie, mro-c3, Moose, and blacklist
    use nextgen;
    
    ## vanilla Moose to follow
    has "foo" => ( isa => "Str", is => "rw" )
    
    package main;
    use nextgen;
    
    ## this works
    my $o = Foo->new;
    
    ## this wouldn't
    ## main is understood to be mode => [qw/procedural])
    my $o = main->new

For now, this module just does

=over 12

=item Perl assertion

asserts 5.10.1+ is loaded -- 5.10.0 is unsupported and not forwards
  compatable because of smart match.

=item strict and warnings

uses the vanilla the strict manpage, and the warnings manpage pragmas

=item features.pm

adds Perl 5.10 the features manpage

=item indirect.pm

disables indirect method syntax via the indirect manpage

=item autodie.pm

throws fatal exceptions in a sane fashion for CORE functions via the autodie manpage

=item mro.pm

C3 method resolution order via the mro manpage

=item Moose.pm

adds the Moose manpage if the package isn't main

=item oose.pm

uses the oose manpage.pm if the program is run via `perl -e', or `perl -E'

=item namespace/autoclean.pm

cleans up the class via the namespace::autoclean manpage if the module has a constructor (sub new).

In the future, the nextgen manpage will include additional CPAN modules which have proven useful and stable.

=back

This module started out as a fork of the Modern::Perl manpage, it wasn't modern enough
and the author wasn't attentive enough to the needs for a more modern perl5.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/n*

%changelog
