%define module_name obogaf-parser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Graph.pm) perl(IO/File.pm) perl(List/MoreUtils.pm) perl(Module/Metadata.pm) perl(PerlIO/gzip.pm) perl(Test/Exception.pm) perl(Test/Files.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.373
Release: alt1
Summary: a perl5 module to handle obo and gaf file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NO/NOT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
obogaf::parser is a perl5 module desinged to handle obo and gene association file. 

=over 2

=item 1. build_edges: extract edges from an obo file. 
    
    my $graph= build_edges(obofile);

obofile: any obo file listed in OBO foundry. The file extension must be ".obo".

output: the graph is returned as tuple: `subdomain <tab> source <tab> destination <tab> relationship'. This means that the graph is returned as a list of edges, where each edge is represented as a pair of vertices in the form `source <tab> destination'. For each couple of nodes, the
subdomain (if any) and the relationships for which is safe group annotations (i.e. `is_a' and `part_of') are returned as well. The graph is stored as an anonymous scalar.

=item 2. build_subonto: extract edges of a specified sub-ontology domain.

    my $subonto= build_subonto(edgesfile, namespace);

edgesfile: a graph in the form: `subdomain <tab> source <tab> destination <tab> relationship'.
This file can be obtained by calling the subroutine `build_edges'.

namespace: name of the subontology for which the edges must be extracted.

output: the graph is returned as a tuple>: `source <tab> destination <tab> relationship'. In other words the graph is returned as a list of edges, where each edge is represented as a pair of vertices in the form `source <tab> destination'. For each couple of nodes the relationships
`is_a' and `part_of' are also returned. The graph is stored as an anonymous scalar.

=item 3. make_stat: make basic statistic on graph.

    my $stat= make_stat(edgesfile, parentIndex, childIndex);

edgesfile: a graph represented as a list of edges, where each edge is stored as a pair of vertices <tab> separated. This file can be obtained by calling the subroutine `build_edges'.

parentIndex: index referring to the column containing the *parent* (source) vertices in *edgesfile* file.

childIndex: index referring to the column containing the *child* vertices (destination) in the *edgesfile* file.

output: statistics about the graph are printed on the sh...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/o*

%changelog
