# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    ogd
%define upstream_version 0.03

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Ordered global destruction of objects stored in globals
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/E/EL/ELIZABETH/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(B.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildArch:  noarch
Source44: import.info

%description
This module adds ordered destruction of objects stored in global variables in
LIFO order during global destruction.

Ordered global destruction is only applicable to objects stored in non-lexical
variables (even if they are in file scope). Apparently Perl destroys all
objects stored file-level lexicals before the first END block is called.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files 
%doc CHANGELOG META.json META.yml  README TODO VERSION
%{perl_vendor_privlib}/ogd.pm

%changelog
