%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) svgalib-devel
# END SourceDeps(oneline)
%define module_version 0.4
%define module_name perl-vgalib
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt7
Summary: Perl extension for svgalib-1.2.11
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SC/SCOTTVR/%module_name-%module_version.tgz

%description
Perl interface to svgalib 1.2.11, which is an enhancement of VGAlib v.1.2.
The main difference in usage is all the vgalib functions that took the
form of vga_functionname are now accessed as vga::functionname (without
the 'vga_') 

Things notably missing from the library:
vga_modeinfo structure_
vga_getmodeinfo()____(vga::getmodeinfo)
vga_getmodename()____(vga::getmodename)__
the pointer to video ram, graph_mem_(\$vga::graphmem)
and the function vga_getgraphmem()_(vga::getgraphmem)

Also, I realize the docs are kinda hacked. If there is any interest in
this package, I will revamp it and reupload it to the CPAN.

Here is a description of the basic library functions (from the original
VGAlib v1.2 README):

    - Support for all standard VGA 16 and 256 color modes
    - Support for non-standard 256 color modes (including mode X)
    - Tseng ET4000 SVGA 256 color modes
    - Monochrome 640x480 mode
    - Text mode restoration
    - Handling of console I/O
    - Flipping between graphics mode and text mode
    - Restores text mode after CTRL-C interrupt
    - The ET4000 modes should now be more robust
    - Tools for creating your own video modes

VGAlib requires the 0.96b kernel (or newer) and must be compiled
with GCC 2.2.2 (or newer). To compile and install VGAlib just
type make. This will also build the following programs:
    vgatest: a simple demonstration of the library and the various
             video modes
    dumpreg: dumps the current VGA registers to stdout, mainly used
             for debugging and creating new video modes
    runx   : if you have problems with text mode restoration after
             running X386, then try to use runx instead of startx
Remember that all programs using VGAlib must be run with setuid
root (login as root and do a 'chmod +s prog-name'), otherwise you
will get a "can't get I/O permissions" error.

VGAlib does it's best to restore the text mode, but it may fail
with some SVGA cards if you use a text mode with more than 80
columns. If you are having problems please try to use an 80
column text mode.

Below is a short description of the functions in the library.
Look at vgatest.c for examples on how to use these functions:
    - vga_setmode() is used to select the graphics mode or to
      restore the text mode.
    - vga_hasmode() tests if a given video mode is supported
      by the graphics card (use this function before using
      any of the ET4000 SVGA modes)
    - vga_clear() clears the graphics screen. This is also done
      by vga_setmode().
    - vga_getxdim(), vga_getydim() and vga_getcolors() return
      the resolution and number of colors for the current mode.
    - vga_getpalette() and vga_getpalvec() returns the contents
      of one or more palette registers, respectively.
    - vga_setpalette() and vga_setpalvec() allows you to modify
      one or more palette registers, respectively.
    - vga_setcolor() determines the color for future calls of
      the drawing functions.
    - vga_drawpixel() and vga_drawline() draws a pixel or a line
      in the current color, respectively.
    - vga_drawscanline() draws one single horisontal line of
      pixels and has been optimized for the fastest possible
      output.
    - vga_screenoff() and vga_screenon() turns the screen refresh
      off and on. On some VGA's the graphics operations will be
      faster, if the screen is turned off during graphics output.
    - vga_flip() switches between graphics and text mode without
      destroying the screen contents. This makes it possible for
      your application to use both text and graphics output.
    - vga_gecth() waits for a character to be typed an returns
      the ASCII value. If you press ESC (the exact key can be
      changed with vga_setflipchar()), the text mode will be
      temporarily restored until you press another key. This allows
      you to switch to another virtual console and later return to
      your graphics application.
    - vga_setflipchar() changes the character that vga_getch()
      uses for flipping between graphics and text mode.
    - vga_dumpregs() dumps the current VGA register contents to
      stdout
My main motivation for implementing the graphics/text flipping was
to make debugging easier. If your program reaches a breakpoint while
in graphics mode, you can switch to text mode with the gdb command

    print vga_flip()

and later restore the graphics screen contents with the same command.
It is usefull to define the following alias in gdb:
in graphics mode, you can switch to text mode with the gdb command

    print vga_flip()

and later restore the graphics screen contents with the same command.
It is usefull to define the following alias in gdb:

    define flip <RETURN> print vga_flip() <RETURN> end <RETURN>              


%prep
%setup -n vgalib

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.v03 Changes
%perl_vendor_archlib/v*
%perl_vendor_autolib/*

%changelog
