# BEGIN SourceDeps(oneline):
BuildRequires: perl(CLI/Framework.pm) perl(CLI/Framework/Command.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter/Lite.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Parser.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(local/lib.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name perlrocks
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: CPAN installation management
Group: Development/Perl
License: cc0
URL: http://github.com/gugod/perlrocks/tree

Source0: http://cpan.org.ua/authors/id/G/GU/GUGOD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This `perlrocks` things provides a mechanism to install multiple
versions of CPAN distributions, and use specific one in programs.

In Perl5, the statement `use Foo 1.0' or `use Foo-1.0' means to load
Foo.pm and check if `$Foo::VERSION' is at least 1.0. perlrocks alters
that behavior to load exactly Foo 1.0. If only higher versions of Foo
are found, it dies.

In order to do that, `perlrocks` makes perl search libs in a different
way. Therefore, you need to install CPAN distributions differently.
To do so, you must use the `perlrocks' command:

    perlrocks install -v 2.0008 Moose
    perlrocks install -v 2.0009 Moose

Also notice here in the document, the term "distribution" is used to
refer to "the thing that gets uploaded to CPAN". Not "module", not
"package". For example, To install MooseX::Struct module, you'll need
to figure out the distribution name that provides it, in this case
it's "MooseX-Struct":

    perlrocks install MooseX-Struct

Since one CPAN distribution can contain as many modules as needed, each
with different versions, it is ambiguous to state the command to install
"Foo::Bar" module, with the version number refering to the "Foo" distribution.

Be aware of that `perlrocks.pm' tweaks your `%%INC', and it maybe
significantly slower. Use it at your own risk.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.mkdn README examples
%perl_vendor_privlib/A*
%perl_vendor_privlib/p*
%perl_vendor_privlib/auto/*
%files scripts
%_bindir/*

%changelog
