# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/CheckManifest.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define module_name pluskeys
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.4
Release: alt1
Summary: pragma to declare class- and typo-safe keys to use in objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `use pluskeys' pragma takes a list of identifiers and creates
constants (zero-argument functions) in the caller's package that return
their own name prefixed with that package.  It is most commonly used 
from within a class definition to declare the object attributes (that 
is, its data members) in a way that can be checked at compile time.

The convention is to use a leading `+' as a "member key" pseudo-prefix
when subscripting the hash.  This really makes something like `+NAME'
get parsed as `NAME()' instead.

That way you can use it as the subscript into a hash and have it be
"typo-checked" under `use strict', because if you try to use one 
of these that you didn't declare, it will look like an illegal
bareword string and make `use strict' blow up at compile time.

For example, given the example in the SYNOPSIS above, this 
would be a syntax error:

    if ($self->{ +SERIAL_NUBMER } =~ /999/) { .... }

Because it would produce an error along these lines (adjusting for
filename and line number):

 Bareword "SERIAL_NUBMER" not allowed while "strict subs" in use at test-pluskeys line 13.

But this would be ok:

    if ($self->{ +SERIAL_NUMBER } =~ /999/) { .... }

Because that would be interpreted as:

    if ($self->{ SERIAL_NUMBER() } =~ /999/) { .... }

And thus (resolving at compile time into):

    if ($self->{ "Some::Package::SERIAL_NUMBER" } =~ /999/) { .... }

The other thing this does is prefix each key with the current package name,
so that `+NAME' is really `Some::Package::NAME'.  That way each class
in an inheritance hierarchy can have its own member data without risk of
trampling on some other class using that same key.  It's the only safe
way to do things when you cannot know what classes will be using what.

The only drawback is that the same notation cannot be used as the left
operand to the `=>' operator.  This doesn't work:

    %%hash = (
        +NAME => "Joe Blow",    # DOESN'T WORK
        +RANK => "peon",        # DOESN'T WORK
    );

Because unlike it use as a braced hash subscr...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/p*

%changelog
