Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# scripts print usage :(
%add_findreq_skiplist %_bindir/p*
BuildRequires: perl-pod
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-pmtools
Version:        2.2.0
Release:        alt2_21
Summary:        A suite of small programs to help manage Perl modules

License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/pmtools
Source:         https://cpan.metacpan.org/authors/id/M/ML/MLFISHER/pmtools-%{version}.tar.gz
# Adapt to Perl 5.26.0 POD changes, bug #1465062, CPAN RT#122210
Patch0:         pmtools-2.0.0-t_pfcat_5.26.patch

BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-doc
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(Getopt/Std.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(perlfaq.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
Source44: import.info

%description
This is pmtools -- a suite of small programs to help manage modules.
The names are totally preliminary, and in fact, so is the code.  We follow
the "keep it small" notion of many tiny tools each doing one thing well,
eschewing giant megatools with millions of options.

Tom Christiansen


%prep
%setup -q -n pmtools-%{version}
%patch0  -p1
find . -type f -perm 755 | xargs perl -pi -MConfig -e 's{^#!/usr/bin/env perl}{$Config{startperl}}'
chmod -c a-x Changes TODO lib/Devel/Loaded.pm


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%{make_build}


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
chmod -R u+w $RPM_BUILD_ROOT/*


%check
# Default perl's pager less fails with /dev/null on stdin (bug #2208970)
export PAGER=/usr/bin/cat
make test


%files
%doc --no-dereference LICENSE
%doc Changes README TODO
%{_bindir}/basepods
%{_bindir}/faqpods
%{_bindir}/modpods
%{_bindir}/pfcat
%{_bindir}/plxload
%{_bindir}/pm*
%{_bindir}/podgrep
%{_bindir}/podpath
%{_bindir}/pods
%{_bindir}/podtoc
%{_bindir}/sitepods
%{_bindir}/stdpods
%{perl_vendor_privlib}/Devel/
%{perl_vendor_privlib}/pmtools.pm
%{_mandir}/man1/basepods.1*
%{_mandir}/man1/faqpods.1*
%{_mandir}/man1/modpods.1*
%{_mandir}/man1/pfcat.1*
%{_mandir}/man1/plxload.1*
%{_mandir}/man1/pm*.1*
%{_mandir}/man1/podgrep.1*
%{_mandir}/man1/podpath.1*
%{_mandir}/man1/pods.1*
%{_mandir}/man1/podtoc.1*
%{_mandir}/man1/sitepods.1*
%{_mandir}/man1/stdpods.1*


%changelog
