%define module_name portable-loader
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(JSON/Eval.pm) perl(Module/Pluggable.pm) perl(MooX/Press.pm) perl(TOML/Parser.pm) perl(Test/Fatal.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: load classes and roles which can be moved around your namespace
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/portable-loader

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The intent of portable::loader is for classes and roles to be portable around
your namespace. The idea is for classes and roles to not know their package
names and not care about their package names. And for them to also not know
or care about the package names of their "friends".

(When I say their friends, I'm talking about a user-agent object which needs
to be able to consume HTTP request objects and return HTTP response objects,
maybe write to a cookie jar object, etc.)

Typically in Perl code, package names are the one thing that is hard-coded
everywhere and this can make things like dependency injection, and API
versioning really difficult to do. Like if you need to make some major
changes to your class's API, do you create an entirely new package with
a different namespace, then wait for your consumers to update? Or do
you keep the old namespace and deal with breakages.

What if instead of doing this:

  use YourAPI::Tree;
  use YourAPI::Leaf;
  
  my $tree = YourAPI::Tree->new;
  $tree->add_leaf(YourAPI::Leaf->new);

People could do this?

  use portable::loader;
  my $api = portable::loader->load("YourAPI");
  
  my $tree = $api->new_tree;
  $tree->add_leaf($api->new_leaf);

The class names are not hard-coded anywhere. They are not even hard-coded
in the definitions of the Leaf and Tree classes.

And there's very little runtime overhead in doing this!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CREDITS README Changes COPYRIGHT
%perl_vendor_privlib/p*

%changelog
