# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/AtRuntime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name preloadable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Require a module during run-time (or compile-time)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/preloadable

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
With PERL_PRELOAD_MODULES unset or false, this statement:

 use preloadable 'Foo';

is basically equivalent to run-time `require()':

 require Foo;

preloadable uses B::Hooks::AtRuntime to perform the `require()' on
runtime. During runtime, you do take a hit of an extra subroutine call.

With PERL_PRELOAD_MODULES set to true, this statement:

 use preloadable 'Foo';

will simply instruct preloadable to `require' `Foo' at compile-time.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/p*

%changelog
