Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Request/Common.pm) perl(IO/Socket/SSL.pm) perl(JSON.pm) perl(JSON/Path.pm) perl(LWP.pm) perl(MIME/Type.pm) perl(Mozilla/CA.pm) perl(Pod/Usage.pm) perl(URI.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-rdapper
Version:        0.08
Release:        alt2_23
Summary:        Command-line RDAP client
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/rdapper
# Upstream source repository is <https://github.com/jodrell/rdapper> as
# announced by the author
# <https://www.ietf.org/mail-archive/web/weirds/current/msg01981.html>.
Source0:        https://cpan.metacpan.org/authors/id/G/GB/GBROWN/rdapper-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
# Run-time:
# No tests, not not run-time time dependencies used
# Getopt::Long not used at tests
# HTTP::Request::Common not used at tests
# IO::Socket::SSL not used at tests
# JSON not used at tests
# JSON::Path not used at tests
# LWP >=6  not used at tests
# LWP::Protocol::https not used at tests
# MIME::Base64 not used at tests
# MIME::Type not used at tests
# Mozilla::CA not used at tests
# Pod::Usage not used at tests
# POSIX not used at tests
# URI not used at tests
# To support HTTPS
Requires:       perl(LWP/Protocol/https.pm)
Source44: import.info

%description
rdapper is a command-line client for the Registration Data Access Protocol
(RDAP), the successor protocol to WHOIS (RFC 3912). RDAP is currently being
developed by the WEIRDS IETF working group <https://tools.ietf.org/wg/weirds/>.

%prep
%setup -q -n rdapper-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference COPYING
%doc README.md
%{_bindir}/rdapper
%{_mandir}/man1/rdapper.*

%changelog
