# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Carp.pm) perl(Devel/StrictMode.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Role/Tiny.pm) perl(Scalar/Util.pm) perl(Syntax/Keyword/Try.pm) perl(Test2/Require/AuthorTesting.pm) perl(Test2/Require/Module.pm) perl(Test2/Tools/Spec.pm) perl(Test2/V0.pm) perl(Type/Nano.pm) perl(Type/Utils.pm) perl(experimental.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name results
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: why throw exceptions when you can return them?
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/results

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a Perl implementation of Rust's standard error handling
mechanism. Rust doesn't have a `try'/`catch'/`throw' mechanism for
throwing errors. Instead, functions can be declared as returning a
"Result" which may be an "Ok" result or an "Err" result. Callers of
these functions will get a compile-time error if they do not inspect
the result and potentially deal with the error. (There is syntactic
sugar for propagating the error further up the call stack.)

Recent versions of Perl provide `try'/`catch'/`throw' (though `throw'
is spelled "die"), and in older versions the same thing can be roughly
accomplished using `eval' or CPAN modules, making Rust's error handling
seem fairly foreign. For this reason I do not recommend using the
a mixture of `try'/`catch'/`throw' error handling and Result-based
error handling in the same codebase. Pick one or the other.

Result-based error handling can provide some pretty succinct idioms,
so I do think it is worthy of consideration.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CREDITS Changes LICENSE README COPYRIGHT
%perl_vendor_privlib/R*
%perl_vendor_privlib/r*

%changelog
