# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Function/Parameters.pm) perl(Moo.pm) perl(Test/Auto.pm) perl(Type/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name routines
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Typeable Method and Function Signatures
Group: Development/Perl
License: perl
URL: http://metacpan.org/release/routines/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AW/AWNCORP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This pragma is used to provide typeable method and function signtures to the
calling package, as well as `before', `after', `around', `augment' and
`override' method modifiers.

  package main;

  use strict;
  use warnings;

  use registry;
  use routines;

  fun hello(Str $name) {
    "hello, $name"
  }

  hello("world");

Additionally, when used in concert with the the registry manpage pragma, this pragma will
check to determine whether a the Type::Tiny manpage registry object is associated with
the calling package and if so will use it to reify type constraints and
resolve type expressions.

  package Example;

  use Moo;

  use registry;
  use routines;

  fun new($class) {
    bless {}, $class
  }

  method hello(Str $name) {
    "hello, $name"
  }

  around hello(Str $name) {
    $self->{name} = $name;

    $self->$orig($name);
  }

  1;

This functionality is based on the Function::Parameters manpage and uses Perl's keyword
plugn API to provide new keywords. As mentioned previously, this pragma makes
the `before', `after', `around', `augment', and `override' method
modifiers available to the calling package where that functionality is already
present in its generic subroutine callback form.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES LICENSE README.md README
%perl_vendor_privlib/r*

%changelog
