%define module_name self
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/Parser.pm) perl(B/OPCheck.pm) perl(Benchmark.pm) perl(ExtUtils/MakeMaker.pm) perl(PadWalker.pm) perl(Sub/Exporter.pm) perl(Test2/V0.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.36
Release: alt1
Summary: provides '$self' in OO code.
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module adds `$self' and `@args' variables in your code. So you
don't need to say:

    my $self = shift;

The provided `$self' and `@args' are lexicals in your sub, and it's
always the same as saying:

    my ($self, @args) = @_;

... in the first line of sub.

However it is not source filtering, but compile-time code
injection. For more info about code injection, see the B::Hooks::Parser manpage
or the Devel::Declare manpage.

It also exports a `self' and a `args' functions. Basically `self' is just
equal to `$_[0]', and `args' is just `$_[1..$#_]'.

For convienence (and backward compatibility), these two functions
are exported by default. If you don't want them to be exported, you
need to say:

    use self ();

Since self.pm uses the Sub::Exporter manpage, the exported <self> funciton
can be renamed:

    use self self => { -as => 'this' };

For more information, see the Sub::Exporter manpage.

It is recommended to use variables instead, because it's much much
faster. There's a benchmark program under "example" directory compare
them: Here's one example run:

    > perl -Ilib examples/benchmark.pl
              Rate  self $self
    self   46598/s    --  -92%%
    $self 568182/s 1119%%    --


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/s*

%changelog
