# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Format.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(HTML/Entities.pm) perl(HTML/Summary.pm) perl(HTML/TreeBuilder.pm) perl(IO/File.pm) perl(LWP/UserAgent.pm) perl(Pod/Usage.pm) perl(Term/ReadKey.pm) perl(Tk.pm) perl(Tk/Dialog.pm) perl(Tk/ROText.pm) perl(URI/URL.pm) perl(WWW/Robot.pm) perl(Encode/JP/H2Z.pm)
# END SourceDeps(oneline)
%define module_version 1.019
%define module_name sitemapper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.019
Release: alt1.1
Summary: script for generating site maps
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AW/AWRIGLEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
sitemapper.pl generates site maps for a given site. It traverses a site from
the root URL given as the -site option and generates an HTML page
consisting of a bulleted list which reflects the structure of the site. 

The structure reflects the distance from the home page of the pages listed;
i.e.  the first level bullets are pages accessible directly from the home page,
the next level, pages accessible from those pages, etc. Obviously, pages that
are linked from "higher" up pages may appear in the "wrong place" in the tree,
than they "belong".

The -format option can be used to specify alternative options for
formating the site map. Currently the options are html (as described above -
the default), js, which uses Jef Pearlman's (jef@mit.edu) Javascript Tree
class to display the site map as a collapsable tree, and text (plain text).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/sitemapper.pl
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\!\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc Changes README examples
%perl_vendor_privlib/W*
%perl_vendor_privlib/L*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
