Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Dist/Zilla/Plugin/MakeMaker/Awesome.pm) perl(Moose.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This file is licensed under the terms of GNU GPLv2+
Name:           perl-smartmatch
Version:        0.05
Release:        alt10_33
Summary:        Pluggable smart matching back-ends
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/smartmatch
Source0:        https://cpan.metacpan.org/authors/id/D/DO/DOY/smartmatch-%{version}-TRIAL.tar.gz
# Restore compatibility with Perl 5.26.0,
# <https://github.com/tokuhirom/B-Tap/issues/4>
Patch0:         smartmatch-0.05-TRIAL-Fix-building-on-Perl-5.25.1.patch
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(B/Hooks/OP/Check.pm)
BuildRequires:  perl(ExtUtils/Depends.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Module/Runtime.pm)
BuildRequires:  perl(Package/Stash.pm)
BuildRequires:  perl(parent.pm)
# Tests:
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Test/Script.pm)


Source44: import.info

%description
This module allows you to override the behavior of the smart match operator
("~~"). "use smartmatch $matcher" hooks into the compiler to replace the
smartmatch opcode with a call to a custom subroutine, specified either as
a coderef or as a string, which will have "smartmatch::engine::" prepended to
it and used as the name of a package in which to find a subroutine named
"match".  The subroutine will be called with two arguments, the values on the
left and right sides of the smart match operator, and should return the
result.

%prep
%setup -q -n smartmatch-%{version}
%patch0 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/smartmatch*

%changelog
