# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name subroutines
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Use subroutines from another module
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/subroutines

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This pragma declares routines in your module that are copied from another
module.

 package Your::Module;
 use subroutines 'Another::Module';

is equivalent to this pseudo-code:

 package Your::Module;
 BEGIN {
     require Another::Module;
     for my $name (all_subroutines_in("Another::Module")) {
         *{"Your::Module::$name"} = \&{"Another::Module::$name"};
     }
 }

This is a form of code reuse when you cannot do:

 package Your::Module;
 use parent 'Another::Module';

because the original subroutines do not expect to be called as methods, and/or
when your subroutines are not called as methods.

Another alternative is to declare `Your::Module' as an alias of
`Another::Module', e.g. using the alias::module manpage.

 package Your::Module;
 use alias::module 'Another::Module';

but this copies everythng, not just subroutines.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/s*

%changelog
