# BEGIN SourceDeps(oneline):
BuildRequires: perl(Audio/FLAC/Header.pm) perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(MP3/Info.pm) perl(Pod/Usage.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.2.1
%define module_name supertag
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: organize your music collection like a real superhero
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AC/ACG/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
There are two primary operating modes of supertag: get mode and set mode. In get mode, metadata is extracted from a succession of sources in each file and printed to standard out. In set mode, metadata is read from standard input and written to all selected sources of each referenced file.

The "editable" input / output format supertag uses by default looks like this:

  ALBUM: Evol
  ARTIST: Sonic Youth
  GENRE: Rock
  PATH: ~/Music/Sonic_Youth_-_Evol/01._Sonic_Youth_-_Tom_Violence.mp3
  TAGVERSION: ID3v2.3.0
  TITLE: Tom Violence
  TRACKNUM: 1
  YEAR: 1986

  ALBUM: Evol
  ARTIST: Sonic Youth
  GENRE: Rock
  PATH: ~/Music/Sonic_Youth_-_Evol/02._Sonic_Youth_-_Shadow_of_a_Doubt.mp3
  TAGVERSION: ID3v2.3.0
  TITLE: Shadow of a Doubt
  TRACKNUM: 2
  YEAR: 1986

Each record corresponds to one file and consists of some number of "key: value" lines. Multiple records are separated by "\n\n". Non-printable or conflicting characters in keys and values are escaped in URL-encoding (`"\n" =' "%%0a">) fashion.

By default, supertag operates on a standard set of metadata sources. Some sources are filetype-specific ("id3v2" only applies to .mp3s) and some are standard ("filename" is always available). supertag will never apply filetype-specific sources to files of the wrong filetype. Two special sources, "audio" and "codec" always give standard digital audio metadata ("SAMPLERATE", "NUMCHANNELS", "SECS", etc.) and encoding-specific metadata (e.g. "MP3_LAYER", "MP3_VBR", etc.), respectively.

In get mode, the special metadata key "PATH" is always added with the full, real path to the file being processed as the value. This metadata key must be present for every input record under set mode.

For performance reasons, filetype is by default determined by looking at file extension. Content-based filetype detection via file(1) can be enabled with the `--mime' flag.

Different audio filetypes are handled through a plugin architecture. This presents a uniform interface to supertag. Developers interested in adding support for new filetypes should subclass all methods in `Audio::SuperTag::Plugin' via a package called e.g. `Audio::SuperTag::Plugin::MYFORMAT'.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
