Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Modern/Perl.pm) perl(SmartMatch/Sugar.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-threads-lite
Version:        0.034
Release:        alt10_32
Summary:        Actor model threading for Perl
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/threads-lite
Source0:        https://cpan.metacpan.org/authors/id/L/LE/LEONT/threads-lite-%{version}.tar.gz
# Tests halt on these platforms, bug #719874, CPAN RT#69354
ExcludeArch:    aarch64 ppc ppc64 ppc64le
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(experimental.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(feature.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Time/HiRes.pm)


Source44: import.info

%description
This module implements threads for perl. One crucial difference with
threads.pm threads is that the threads are disconnected, except by message
queues. It thus facilitates a message passing style of multi-threading.

%prep
%setup -q -n threads-lite-%{version}

%build
perl Build.PL installdirs=vendor optimize="$RPM_OPT_FLAGS"
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes examples README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/threads*

%changelog
