%set_verify_elf_method none
%add_findreq_skiplist %perl_vendor_privlib/Uplug/Web*
%add_findreq_skiplist %perl_vendor_privlib/auto/*

# BEGIN SourceDeps(oneline):
BuildRequires: java-devel-default perl(AnyDBM_File.pm) perl(CGI.pm) perl(CGI/Carp.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DB_File.pm) perl(Data/Dumper.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/Command.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Compare.pm) perl(File/Copy.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(GDBM_File.pm) perl(Getopt/Std.pm) perl(HTML/Entities.pm) perl(IO.pm) perl(IO/File.pm) perl(IPC/Run.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Mail/Mailer.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POSIX.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Storable.pm) perl(Sys/Hostname.pm)
BuildRequires: perl(Test/More.pm) perl(XML/Parser.pm) perl(XML/Simple.pm) perl(YAML/Tiny.pm) perl(autouse.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.3.8
%define module_name uplug-main
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.8
Release: alt4
Summary: a toolbox for processing (parallel) text corpora
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TI/TIEDEMANN/%{module_name}-%{module_version}.tar.gz
Patch: Uplug-0.3.8-alt-perl526.patch
BuildArch: noarch

%description
This library provides the main methods for loading Uplug modules and running them. Configuration files describe the module and its parameters (see the Uplug::Config manpage). Each module may contain a number of sub-modules. Each of them can usually calls the uplug scripts provided in the package.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n Uplug-%{module_version}
%patch -p1

rm t/40_PosTag.t

%build
%perl_vendor_build

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	sed -i -e '1s,^#\!\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*Mode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc README LICENSE CHANGES doc example
%perl_vendor_privlib/U*
%perl_vendor_privlib/auto/share/dist/*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
