# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(re.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name warnings-regex-recompile
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Get Warnings about regex/pattern recompilation in Perl code.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KP/KPAWAR/%{module_name}-%{module_version}.zip
BuildArch: noarch

%description
warnings::regex::recompile gives Warnings with the line numbers if any regex/patten is getting recompiled in Perl code .

It is Prgamatic module, so one can use it like this;

use warnings::regex::recompile;

Example,
#strings.pl

my @regexps = qw( foo bar baz );
my @strings = qw( abc def ghi );

for my $string (@strings) {

   for my $regex (@regexps) {

      $string =~ /$regex/
   
   }

}

In this case, warning will be like this,

[ WARNING : Pattern bar is getting re-compiled on 7 in strings.pl. You are advised to use qr// operator, which boost the speed/performance of your code. ]

[ WARNING : Pattern baz is getting re-compiled on 7 in strings.pl. You are advised to use qr// operator, which boost the speed/performance of your code. ]

[ WARNING : Pattern foo is getting re-compiled on 7 in strings.pl. You are advised to use qr// operator, which boost the speed/performance of your code. ]



This module also figure out the variable name if the variable has dynamic regex. for exa:

#Time.pl
my $a = "abcdefghijklmnopqrstuvwxyz"; 
my $b = 1; 

for (1..1000) { 
_
_$b = ($b + 1) %% 10; 
_
_#print "b : $b\n";
__
_$a =~ s/$b a//; 
} 

In this case, warning will be like this,

[ WARNING : Variable $b is getting re-compiled on 19 in Time.pl. You are advised to use qr// operator, which boost the speed/performance of your code. ]

#Module gives [NO WARNINGS !!!] if there is no regex/pattern getting recompiled.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/w*

%changelog
