# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name yEd-Document
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: pure perl API to easily create yEd-loadable Documents from scratch (using XML::LibXML)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FI/FINCHI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This package provides a pure object oriented implementation, so only use functions and properties of yEd::Document and the other types in the context of a blessed instance.

Minimal example (creating an empty, yEd loadable Document):

    use yEd::Document;
    # create the document
    $d = yEd::Document->new();
    # build the document
    $xmlstring = $d->buildDocument();
    # or
    $d->buildDocument('/mypath/mydocument');

Example of different ways to create a Node with Label (all have the same effect on the Document):

    # the manual approach
    my $n = yEd::Node::ShapeNode->new('myid1');
    $n->x(50);
    $n->y(150);
    my $l = yEd::Label::NodeLabel->new('hello world');
    $n->addLabel($l);
    $doc->addNode($n);

    # a slightly more user friendly approach
    # provide the propertys with constructor and don't deal with IDs
    my $n = yEd::Node::ShapeNode->new($doc->getFreeId(), 'x' => 50, 'y' => 150);
    # directly add the label
    my $l = $n->addNewLabel('hello world');
    $doc->addNode($n);

    # or do it all in two lines
    my $n = $doc->addNewNode('ShapeNode', 'x' => 50, 'y' => 150);
    my $l = $n->addNewLabel('hello world');

    # or in one if you don't need the node ref (label ref is returned)
    my $l = $doc->addNewNode('ShapeNode', 'x' => 50, 'y' => 150)->addNewLabel('hello world');

    # or use templating if you need many copies of the same node
    my $l = $doc->addNewNodeTemplate('mytemplate', 'ShapeNode', 'x' => 50, 'y' => 150)->addNewLabel('hello world');
    my $n = $doc->addTemplateNode('mytemplate');
    # you can use $n to modify the copy (e.g. coords), you can also provide new properties with the call to addTemplateNode()
    # creating edges can be done in nearly the same ways

Example of using relative entities and layers (ready to run):

    use strict;
    use yEd::Document;
    
    my $d = yEd::Document->new();
    # play around with these values and note that the edge will always keep its right angles :)
    my $sx = -15; # -0.5 * default width 
    my $sy = 15; # 0.5 * default height -> lower left corner of source
    my $tx = 15; # 0.5 * default width 
    my $ty = 15; # 0.5 * default height -> lower right corner of target
    my $distance = 250;
    
    # place the absolute "root" node
    my $grouproot = $d->addNewNode('ShapeNode', 'x' => 1000, 'y' => 1000);
    # place another node $distance units to its right (or left if negative)
    my $n = $d->addNewNode('ShapeNode', 'x' => $distance, 'y' => 0, 'relative' => $grouproot);
    # place an edge on both which will go 50 units down, then $distance units (modified by anchor offsets) right/left (and then up again to connect to its target)
    my $e = $d->addNewEdge('PolyLineEdge', $grouproot, $n, 'relativeWaypoints' => 1, 'sx' => $sx, 'sy' => $sy, 'tx' => $tx, 'ty' => $ty);
    $e->waypoints([0,50],[$distance - $sx + $tx,0]);
    # place a circle on top of $grouproot to make the "group movement" visible in yEd
    my $c = $d->addNewNode('ShapeNode','shape' => 'ellipse', 'layer' => 1, 'x' => 1000, 'y' => 1000);
    $d->addNewEdge('PolyLineEdge', $n, $c, 'tArrow' => 'standard', 'sArrow' => 'standard');
    # you can now move the whole "group" by modifying $grouproot's x and y values (uncomment it and watch the difference in yEd)
    #$grouproot->setProperties('x' => 778.88, 'y' => 900);
    
    $d->buildDocument('test');

Example of using templating (ready to run):

    use strict;
    use yEd::Document;
    
    my $d = yEd::Document->new();
    
    # preparing the templates
    $d->addNewLabelTemplate('headline', 'NodeLabel', 'The house of Santa Claus', 'positionModell' => 'sandwich-n', 'fontSize' => 20);
    $d->addNewNodeTemplate('housenode', 'ShapeNode', 'shape' => 'ellipse', 'fillColor' => '#0000ff');
    my $wall = $d->addNewEdgeTemplate('wall', 'GenericEdge', 'lineWidth' => 5, 'fillColor' => '#0000ff', 'tArrow' => 'standard');
    $wall->addNewLabel('This', 'positionModell' => 'three_center-scentr', 'textColor' => '#005500', 'backgroundColor' => '#cccccc');
    $d->addEdgeTemplate('roof', $wall, 'fillColor' => '#ff0000');
    
    # adding the nodes
    my $n = $d->addTemplateNode('housenode', 'y' => 300);
    my $n1 = $d->addTemplateNode('housenode');
    my $n2 = $d->addTemplateNode('housenode', 'x' => 300);
    my $n3 = $d->addTemplateNode('housenode', 'x' => 300, 'y' => 300);
    # adding a node that wasn't defined as a template
    my $n4 = $d->addNewNode('ShapeNode', 'x' => 150, 'y' => -150, 'shape' => 'triangle', 'fillColor' => '#ff0000');
    $n4->addLabel($d->getTemplateLabel('headline'));
    
    # adding the edges
    $d->addTemplateEdge('wall',$n,$n1);
    ($d->addTemplateEdge('wall',$n1,$n2)->labels())[0]->text('is');
    ($d->addTemplateEdge('wall',$n2,$n)->labels())[0]->text('the');
    ($d->addTemplateEdge('wall',$n,$n3)->labels())[0]->text('house');
    ($d->addTemplateEdge('wall',$n3,$n2)->labels())[0]->text('of');
    ($d->addTemplateEdge('roof',$n2,$n4)->labels())[0]->text('San-');
    ($d->addTemplateEdge('roof',$n4,$n1)->labels())[0]->text('ta');
    ($d->addTemplateEdge('wall',$n1,$n3)->labels())[0]->text('Claus');
    
    $d->buildDocument('santa_claus');
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/y*

%changelog
