# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           petit
Version:        1.1.1
Release:        alt1_13
Summary:        Log analysis tool for syslog, Apache and raw log files

Group:          System/Base
License:        GPLv3+
URL:            http://crunchtools.com/software/petit/
Source0:        http://crunchtools.com/wp-content/files/%{name}/%{name}-%{version}.tgz

BuildArch:      noarch
BuildRequires:  python-devel
Source44: import.info

%description
Log analysis tool which is useful to systems administrators & systems
analysts. It interacts with syslog and Apache logs to clarify what is
happening in logs.


%prep
%setup -q -n %{name}

# Remove binary manpage
rm -f src/man/*.gz

# Remove hidden svn folders
find -type d -name .svn | xargs rm -rf

# Replace (hardcoded) wrong path: /var/lib -> /usr/share
find src -type f -exec sed -i -e 's|/var/lib|%{_datadir}|' {} \;


%build
# Nothing to do


%install
pushd src
install -d ${RPM_BUILD_ROOT}%{_bindir}/
install -m755 bin/petit ${RPM_BUILD_ROOT}%{_bindir}/
install -d ${RPM_BUILD_ROOT}%{_datadir}/petit/
install -d ${RPM_BUILD_ROOT}%{_datadir}/petit/crunchtools/
install -m644 lib/crunchtools/*.py ${RPM_BUILD_ROOT}%{_datadir}/petit/crunchtools/
install -d ${RPM_BUILD_ROOT}%{_datadir}/petit/filters/
install -m644 lib/filters/*.stopwords ${RPM_BUILD_ROOT}%{_datadir}/petit/filters/
install -d ${RPM_BUILD_ROOT}%{_datadir}/petit/fingerprints/
install -m644 lib/fingerprints/*.fp ${RPM_BUILD_ROOT}%{_datadir}/petit/fingerprints/
install -d ${RPM_BUILD_ROOT}%{_datadir}/petit/fingerprint_library/
install -m644 lib/fingerprint_library/*.fp ${RPM_BUILD_ROOT}%{_datadir}/petit/fingerprint_library/
install -d ${RPM_BUILD_ROOT}%{_mandir}/man1/
install -m644 man/petit.1 ${RPM_BUILD_ROOT}%{_mandir}/man1/
popd

 

%files
%doc AUTHORS COPYING README
%{_bindir}/petit
%{_datadir}/petit/
%{_mandir}/man1/petit.1.*


%changelog
