Group: Databases
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/Trig.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Spherical data types, functions, and operators for PostgreSQL
Name: pgsphere
Version: 1.1.1
Release: alt1_38
License: BSD

# https://github.com/akorotkov/pgsphere/issues/15
Source0: http://pgfoundry.org/frs/download.php/2558/%{name}-%{version}.tar.gz
Patch0: pgsphere-pgsl93.patch
# The changes are upstream already, fixed via a number of different commits.
# Most of the changes seem to be in this one 2d97f1652afb4ef5405e0e1e5988c.
Patch1: pgsphere-pgsl11.patch
Patch2: pgsphere-pgsl12.patch
URL: http://pgfoundry.org/projects/pgsphere

BuildRequires: gcc
BuildRequires: postgresql-server-devel
BuildRequires: clang-devel
BuildRequires: llvm16.0-devel
%{?postgresql_module_requires}
Source44: import.info

%description
pgSphere is a server side module for PostgreSQL. It contains methods for 
working with spherical coordinates and objects. It also supports indexing of 
spherical objects.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%make_build USE_PGXS=1 PG_CONFIG=%_bindir/pg_server_config

%install
install -d %{buildroot}%{_libdir}/pgsql/
install -d %{buildroot}%{_datadir}/%{name}

install -m 755 pg_sphere.so %{buildroot}%{_libdir}/pgsql/pg_sphere.so
install -m 644 pg_sphere.sql %{buildroot}%{_datadir}/%{name}/



%files
%doc README.pg_sphere
%doc --no-dereference COPYRIGHT.pg_sphere
%{_datadir}/%{name}
%{_libdir}/pgsql/pg_sphere.so

%changelog
