Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pidgin-save-conv-order
Version:        1.0
Release:        alt2_14
Summary:        Pidgin plugin to save order
Summary(de):    Pidgin Konversationsreihenfolge speichern
Summary(sr):    Сачувај редослед разговора
Summary(fr):    Enregistrer l'ordre des conversations

License:        GPLv2+
URL:            https://github.com/kgraefe/%{name}
Source0:        https://github.com/kgraefe/%{name}/releases/download/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  pidgin-devel
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  intltool

Requires:       pidgin

%global plugindir %(pkg-config --variable=plugindir pidgin)
Source44: import.info

%description
This plugin saves the order of the chats and IMs and restores it the next time
you open a conversation.

%description -l de
Dieses Plugin speichert die Reihenfolge von Chats und IMs und stellt diese
wieder her, wenn eine neue Konversation geöffnet wird.

%description -l sr
Овај прикључак чува редослед ћаскања и брзих порука и враћа их приликом
следећег отварања разговора.


%prep
%setup -qn %{name}-%{version}

%build
%configure
%make_build

%install
make install DESTDIR=%{buildroot} plugindir=%{plugindir}
rm -f %{buildroot}%{plugindir}/save_conv_order.{la,a}
%find_lang %{name}

%check
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/appdata/%{name}.metainfo.xml

%files -f %{name}.lang
%doc AUTHORS.md CHANGES.md README.md
%doc --no-dereference COPYING
%{plugindir}/save_conv_order.so
%{_datadir}/appdata/%{name}.metainfo.xml

%changelog
