Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pypi_name pipsi

# test suite is disabled by default for koji builds,
# because tests require internet connection

# Conditial build macro
# http://www.rpm.org/wiki/PackagerDocs/ConditionalBuilds
%bcond_with tests

Name:           %{pypi_name}
Version:        0.9
Release:        alt1_17
Summary:        Wraps pip and virtualenv to install scripts

License:        BSD
URL:            http://github.com/mitsuhiko/pipsi/
Source0:        https://pypi.python.org/packages/source/p/%{pypi_name}/%{pypi_name}-%{version}.tar.gz
BuildArch:      noarch
 
BuildRequires:  python3-devel
BuildRequires:	python3-module-click
BuildRequires:	python3-module-virtualenv

%if %{with tests}
# Required for tests
BuildRequires:	pytest3 python3-module-pytest
BuildRequires:	libssl-devel
BuildRequires:	libacl-devel
%endif

Requires:       python3-module-click
Requires:       python3-module-distribute
Requires:       python3-module-virtualenv	
Source44: import.info

%description
Pipsi is a wrapper around virtualenv and pip which installs scripts provided
by python packages into separate virtualenvs to shield them from your system
and each other.


%prep
%setup -q -n %{pypi_name}-%{version}
# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

# Point to namespaced Python 3 version of virtualenv executable if available
for cand in virtualenv-3 py3-virtualenv; do
    if [ -e "%{_bindir}/$cand" ]; then
        sed -i "233 s/virtualenv/$cand/" %{pypi_name}.py
        sed -i "70 s/virtualenv/$cand/" get-%{pypi_name}.py
        break
    fi
done


%build
%python3_build


%install
%python3_install


%if %{with tests}
%check
# Tests need UTF-8 encoding
export LC_CTYPE="C.UTF-8"
# Invoke tests and disable the test that checks if pipsi is already installed
%{__python3} -m pytest -k "not test_find_scripts" -vv
%endif


%files
%doc README.rst
%doc --no-dereference LICENSE
%{_bindir}/pipsi
%{python3_sitelibdir_noarch}/%{pypi_name}.py
%{python3_sitelibdir_noarch}/__pycache__/*
%{python3_sitelibdir_noarch}/%{pypi_name}-%{version}-py%{__python3_version}.egg-info

%changelog
