# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(AppConfig.pm) perl(CGI.pm) perl(CGI/Carp.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pisg
Version:        0.73
Release:        alt1_12
Summary:        An IRC channel statics generator
License:        GPL
Group:          Networking/IRC
URL:            http://pisg.sourceforge.net/
Source0:        https://downloads.sourceforge.net/pisg/%{name}-%{version}.tar.gz

BuildRequires:  perl

BuildArch:      noarch
Source44: import.info

%description
pisg is an IRC channel statics generator written in Perl, it creates
statistics from different logfile formats. It was originally written
because IRCStats wasn't open source. So here's an open source/GPL'ed
version to anyone interested. It's a funny thing for your IRC channel,
and it's highly customizable.


%prep
%setup -q

%build
# Some default configuration setting
perl -pi -e "s:configfile => 'pisg.cfg':configfile => '%{_sysconfdir}/pisg.cfg':" modules/Pisg.pm
perl -pi -e "s:langfile => 'lang.txt':langfile => '%{_datadir}/%{name}/lang.txt':" modules/Pisg.pm
perl -pi -e "s:cssdir => 'layout/':cssdir => '%{_datadir}/%{name}/layout/':" modules/Pisg.pm

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{perl_vendor_privlib}
mkdir -p %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_sysconfdir}

install -m 755 pisg %{buildroot}%{_bindir}
cp -ar modules/* %{buildroot}%{perl_vendor_privlib}
cp -ar lang.txt layout %{buildroot}%{_datadir}/%{name}
cp -a pisg.cfg %{buildroot}%{_sysconfdir}

find %{buildroot}%{perl_vendor_privlib} -type f -exec chmod 644 {} \;

%files
%doc README docs
%doc scripts gfx
%{_bindir}/%{name}
%{perl_vendor_privlib}/*
%{_datadir}/%{name}
%config(noreplace) %{_sysconfdir}/pisg.cfg


%changelog
