Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pkgdiff
Version:        1.7.2
Release:        alt2_18
Summary:        A tool for analyzing changes in Linux software packages

License:        GPLv2+
URL:            http://lvc.github.io/pkgdiff/
Source0:        https://github.com/lvc/%{name}/archive/%{version}.tar.gz#/%{name}-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  help2man

Requires:       diffutils
Requires:       wdiff
Requires:       binutils
Requires:       gawk
Requires:       abi-compliance-checker >= 1.99.1
Requires:       abi-dumper >= 0.97
Source44: import.info


%description
Package Changes Analyzer (pkgdiff) is a tool for analyzing changes
in Linux software packages (RPM, DEB, TAR.GZ, etc). The tool is
intended for Linux maintainers who are interested in ensuring
compatibility of old and new versions of packages.


%prep
%setup -q
chmod 0644 LICENSE README
chmod 0755 %{name}.pl


%build
# Nothing to build.


%install
mkdir -p %{buildroot}%{_prefix}
mkdir -p %{buildroot}%{_mandir}/man1
perl Makefile.pl -install --prefix=%{_prefix} --destdir=%{buildroot}

# Generate man page
cp %{name}.pl %{name}
%if 0%{?rhel} && 0%{?rhel} <= 6
help2man -N -o %{name}.1 ./%{name}
%else
help2man -N --no-discard-stderr -o %{name}.1 ./%{name}
%endif
sed -i 's/\(.\)/\n\1/' %{name}.1
sed -i 's/PACKAGE/PKGDIFF/g' %{name}.1
install -m 0644 %{name}.1 %{buildroot}%{_mandir}/man1


%files
%doc --no-dereference LICENSE
%doc README doc/*
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_mandir}/man1/*


%changelog
