# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          processing
Version:       1.5.1
Release:       alt1_9
Summary:       An open source programming language and environment for images, animation, and interactions
Group:         Development/Java
License:       GPLv2
Url:           http://code.google.com/p/processing/
# full package require android sdk from http://www.android.com/
# svn export http://processing.googlecode.com/svn/tags/processing-1.5.1
# rm -rf processing-1.5.1/android processing-1.5.1/java
# TODO
# java/core/libraries/dxf/dxfviewer.jar
# java/core/libraries/javascript/library/javascript.jar
# java/core/libraries/minim/library/jl1.0.jar
# java/core/libraries/minim/library/jsminim.jar
# java/core/libraries/minim/library/minim.jar
# java/core/libraries/minim/library/minim-spi.jar
# java/core/libraries/minim/library/mp3spi1.9.4.jar
# java/core/libraries/minim/library/tritonus_aos.jar
# java/core/libraries/minim/library/tritonus_share.jar
# java/core/libraries/opengl/library/gluegen-rt.jar
# jogl 2.x
# java/core/libraries/opengl/library/.jar
# java/core/libraries/opengl2/library/gluegen-rt.jar
# java/core/libraries/opengl2/library/jogl.all.jar
# java/core/libraries/opengl2/library/nativewindow.all.jar
# java/core/libraries/pdf/itext-src.zip
# java/core/libraries/pdf/library/itext.jar
# java/core/libraries/serial/library/RXTXcomm.jar
# java/core/libraries/video/QTJava.zip
# rm -rf processing-1.5.1/app/src/processing/app/macosx processing-1.5.1/app/src/processing/app/windows
# rm -rf processing-1.5.1/build processing-1.5.1/javascript
# tar czf processing-1.5.1-src-svn.tar.gz processing-1.5.1
Source0:       processing-1.5.1-src-svn.tar.gz

BuildRequires: ant
BuildRequires: antlr-tool
BuildRequires: ant-antlr
BuildRequires: ecj
BuildRequires: java-devel-default /proc
BuildRequires: jna
BuildRequires: javapackages-tools
BuildRequires: junit
Requires:      javapackages-tools
BuildArch:     noarch
Source44: import.info

%description
Processing is an open source programming language and
environment for people who want to program images,
animation, and interactions. It is used by students, artists,
designers, researchers, and hobbyists for learning, 
prototyping, and production. It is created to teach
fundamentals of computer programming within a visual context and
to serve as a software sketchbook and professional production tool.

%package core
Group:         Development/Java
Summary:       Core libraries for %{name}
Requires:      javapackages-tools

%description core
An open source programming language and environment for images, animation, and interactions.

This package contains Core libraries for %{name}.

%package app
Group:         Development/Java
Summary:       App libraries for %{name}
Requires:      %{name}-core = %{version}-%{release}
Requires:      jna
Requires:      javapackages-tools

%description app
An open source programming language and environment for images, animation, and interactions.

This package contains App libraries for %{name}.

%prep
%setup -q -n processing-%{version}
for j in $(find . -name "*.jar"); do
  mv $j $j.no
done

for c in $(find . -name "*.class"); do
  rm -rf $c
done

pushd app
	pushd test/lib
#		app/test/lib/junit-4.8.1.jar.no
		ln -sf $(build-classpath junit4) junit-4.8.1.jar
	popd
	pushd lib
#		app/lib/antlr.jar.no
		ln -sf $(build-classpath antlr) .
#		app/lib/ecj.jar.no
		ln -sf $(build-classpath ecj) .
#		app/lib/ant-launcher.jar.no
		ln -sf $(build-classpath ant-launcher) .
#		app/lib/jna.jar.no
		ln -sf $(build-classpath jna) .
#		app/lib/ant.jar.no
		ln -sf $(build-classpath ant) .
#		app/lib/apple.jar.no
	popd
popd

%build
export JAVA_HOME=%{_jvmdir}/java
pushd core
	pushd methods
#		core/methods/methods.jar.no
		ant
	popd
	ant
popd
pushd app
	ant
popd

%install
mkdir -p %{buildroot}%{_javadir}/processing
install -pm 644 core/methods/methods.jar %{buildroot}%{_javadir}/processing/
install -pm 644 core/core.jar %{buildroot}%{_javadir}/processing/
install -pm 644 app/pde.jar %{buildroot}%{_javadir}/processing/

%files core
%{_javadir}/processing/core.jar
%{_javadir}/processing/methods.jar
%doc done.txt license.txt todo.txt

%files app
%{_javadir}/processing/pde.jar



%changelog
