Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/clang-tidy /usr/bin/cppcheck
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global debug_package %{nil}

Name:           protozero
Version:        1.7.1
Release:        alt1_8
Summary:        Minimalistic protocol buffer decoder and encoder in C++

License:        BSD-2-Clause
URL:            https://github.com/mapbox/protozero
Source0:        https://github.com/mapbox/%{name}/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz

BuildRequires:  ctest cmake gcc-c++
BuildRequires:  doxygen graphviz libgraphviz
BuildRequires:  libprotobuf-devel libprotobuf-lite-devel protobuf-compiler
BuildRequires:  catch2-devel
Source44: import.info

%description
Minimalistic protocol buffer decoder and encoder in C++.

Designed for high performance. Suitable for writing zero copy parsers
and encoders with minimal need for run-time allocation of memory.

Low-level: this is designed to be a building block for writing a
very customized decoder for a stable protobuf schema. If your protobuf
schema is changing frequently or lazy decoding is not critical for your
application then this approach offers no value: just use the decoding
API available via the C++ API that can be generated via the Google
Protobufs protoc program.


%package        devel
Group: Other
Summary:        Development files for %{name}
Provides:       %{name}-static = %{version}-%{release}

%description    devel
Minimalistic protocol buffer decoder and encoder in C++.

Designed for high performance. Suitable for writing zero copy parsers
and encoders with minimal need for run-time allocation of memory.

Low-level: this is designed to be a building block for writing a
very customized decoder for a stable protobuf schema. If your protobuf
schema is changing frequently or lazy decoding is not critical for your
application then this approach offers no value: just use the decoding
API available via the C++ API that can be generated via the Google
Protobufs protoc program.


%prep
%setup -q -n %{name}-%{version}

rm -rf test/catch
ln -sf /usr/include/catch2 test/catch
mkdir build


%build
%{fedora_v2_cmake} -DWERROR=OFF
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install


%check
%fedora_v2_ctest


%files devel
%doc README.md doc/*.md %{__cmake_builddir}/doc/html
%doc --no-dereference LICENSE.md LICENSE.from_folly
%{_includedir}/protozero


%changelog
