Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-generic-compat
BuildRequires: perl(DBD/mysql.pm) perl(DBI.pm)
# END SourceDeps(oneline)
BuildRequires: libpcrecpp-devel python3-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:       A high-performance MySQL proxy
Name:          proxysql
Version:       2.3.2
Release:       alt1_1
# Proxysql Google group for free community support: https://groups.google.com/g/proxysql
URL:           http://www.proxysql.com/
# The entire source code is GPLv3+ except deps/re2 and deps/jemalloc which is BSD
# and deps/mariadb-connector-c which is LGPLv2+
# and prometheus-cpp which is MIT
License:       GPLv3+ and LGPLv2+ and BSD and MIT

BuildRequires: automake
BuildRequires: ctest cmake, gcc-c++
BuildRequires: rpm-macros-systemd

# Required by proxysql code
BuildRequires: libtool
BuildRequires: libpcre-devel libpcrecpp-devel
BuildRequires: zlib-devel
BuildRequires: libev-devel
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libcurl-devel
BuildRequires: libdaemon-devel
BuildRequires: libconfig-c++-devel libconfig-devel, liblz4-devel

# Used by provided (scripts) tools
BuildRequires: perl

# Specific dependency for Fedora/RHEL/Centos
BuildRequires: libgnutls-devel libgnutlsxx-devel

Requires: mariadb-client

# Build in other architectures aside from x86 is not yet supported due to some
# use of assembly code, but is on the upstream roadmap to support them.
# https://github.com/sysown/proxysql/issues/977

# Update 8/2021
# Support for arm64 has been added.
ExcludeArch:   %{power64} s390x

Provides:      bundled(jemalloc) = 5.2.0
Provides:      bundled(mariadb-connector-c) = 3.1.9
Provides:      bundled(re2) = 20200706
# Provided source package for clickhouse-cpp was not officially versioned.
Provides:      bundled(clickhouse-cpp)
Provides:      bundled(prometheus-cpp) = v9.0
Provides:      bundled(cityhash) = 1.1.1
Provides:      bundled(libhttpserver) = 0.18.1
Provides:      bundled(libmicrohttpd) = 0.9.68

# There is inconsistency between name and URL of file and main unpacked source folder
Source0:       https://github.com/sysown/proxysql/archive/refs/tags/v%{version}.tar.gz
Source1:       proxysql.service
# Manpage for binary is missing. Instead we provide it manually.
# Link for tracking current status in upstream:
# https://github.com/sysown/proxysql/issues/3564
Source2:       proxysql.1

# The upstream code bundles multiple libraries: libconfig, libdaemon, sqlite3, re2,
# mariadb-connector-c, pcre, clickhouse-cpp, prometheus-cpp, lz4, cityhash, microhttpd, curl
# ev, coredumper, libssl and jemalloc.
# This patch de-bundles 8 of these libraries: libconfig, libdaemon and sqlite3,
# libsl, pcre, curl, lz4, ev
# The remaining libraries are not de-bundled due to different reasons (mainly
# being patched, more info here: https://bugzilla.redhat.com/show_bug.cgi?id=1457929).
# Other remaining libraries are not maintained in Fedora (clickhouse-cpp,
# cityhash, prometheus-cpp)

# Provides debundling bundled libraries
Patch0: proxysql_debundle.patch
# Provides lininject convertion to python3
Patch1: libinjection_python2_to_3.patch
# Provides fixes for gcc compiler
Patch2: %{name}-gcc11.patch
# Provides fixes for cmake scheme
Patch3: %{name}_mariadb_cmake.patch
# Removes deprecated openssl function
Patch4: %{name}_openssl.patch
Source44: import.info

%description
ProxySQL is a high performance, high availability, protocol aware proxy for
MySQL and forks (like Percona Server and MariaDB).

%prep
%setup -q -n %{name}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

# Remove sources of debundled libraries from v2.2.0
rm -r deps/{libssl,pcre,curl,lz4,libev,libconfig,libdaemon,sqlite3}

%build
%add_optflags -I/usr/include/pcre
%global _configure_script :
%configure help
export CPPFLAGS=$CXXFLAGS
%make_build

%install
install -p -D -m 0755 src/proxysql %{buildroot}%{_bindir}/proxysql
install -p -D -m 0640 etc/proxysql.cnf %{buildroot}%{_sysconfdir}/proxysql.cnf
install -p -D -m 0755 tools/proxysql_galera_checker.sh %{buildroot}%{_datadir}/%{name}/tools/proxysql_galera_checker.sh
install -p -D -m 0755 tools/proxysql_galera_writer.pl %{buildroot}%{_datadir}/%{name}/tools/proxysql_galera_writer.pl
install -p -D -m 0644 %{SOURCE1} %{buildroot}%{_unitdir}/%{name}.service
install -p -D -m 0644 README.md %{buildroot}%{_docdir}/proxysql/README.md
install -p -D -m 0644 RUNNING.md %{buildroot}%{_docdir}/proxysql/RUNNING.md
install -p -D -m 0644 FAQ.md %{buildroot}%{_docdir}/proxysql/FAQ.md
install -p -D -m 0644 doc/release_notes/*.md -t %{buildroot}%{_docdir}/proxysql
install -p -D -m 0644 doc/internal/*.txt -t %{buildroot}%{_docdir}/proxysql
install -p -D -m 0644 %{SOURCE2} %{buildroot}%{_mandir}/man1/%{name}.1
install -d -m 0755 %{buildroot}%{_sharedstatedir}/proxysql

%pre
/usr/sbin/groupadd -r proxysql >/dev/null 2>&1 || :
/usr/sbin/useradd  -g proxysql -r -d /var/lib/proxysql -s /sbin/nologin \
    -c "ProxySQL" proxysql >/dev/null 2>&1 || :

%post
%post_service proxysql

%preun
%preun_service proxysql

%files
%{_bindir}/*
%{_unitdir}/*
%{_datadir}/%{name}
%{_docdir}/%{name}
%{_mandir}/man1/*
%doc --no-dereference LICENSE
%attr(-,proxysql,proxysql) %{_sharedstatedir}/%{name}
%attr(-,proxysql,root) %config(noreplace) %{_sysconfdir}/%{name}.cnf

%changelog
