Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           proxytunnel
Version:        1.10.20200907
Release:        alt2_10
Summary:        Tool to tunnel a connection through an standard HTTP(S) proxy

License:        GPLv2+ and BSD and MIT
URL:            https://github.com/proxytunnel/proxytunnel
Source0:        https://github.com/proxytunnel/proxytunnel/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  asciidoc asciidoc-a2x
BuildRequires:  coreutils
BuildRequires:  gcc
BuildRequires:  libssl-devel
BuildRequires:  xmlto
Source44: import.info

%description
ProxyTunnel is a program that connects stdin and stdout to a server somewhere 
on the network, through a standard HTTPS proxy. We mostly use it to tunnel SSH
sessions through HTTP(S) proxies.
Proxytunnel can currently do the following:
* Create tunnels using HTTP and HTTPS proxies (That understand the HTTP 
  CONNECT command).
* Work as a back-end driver for an OpenSSH client, and create SSH
  connections through HTTP(S) proxies.
* Work as a stand-alone application, listening on a port for connections, 
  and then tunneling these connections to a specified destination. 

%prep
%setup -q

# Fix permissions
chmod -c 644 CHANGES
# Convert docs to UTF-8
for f in CHANGES; do
    iconv -f iso-8859-1 -t utf-8 $f > $f.tmp
    touch -r $f $f.tmp
    mv -f $f.tmp $f
done

%build
%make_build CFLAGS="%{optflags}"

%install
%makeinstall_std prefix=%{_prefix} DESTDIR=%{buildroot}

%files
%doc CHANGES CREDITS KNOWN_ISSUES README.md TODO
%doc --no-dereference LICENSE.txt
%{_bindir}/proxytunnel
%{_mandir}/man1/proxytunnel.1*

%changelog
