# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
# END SourceDeps(oneline)
%define oldname python-asciitable
%define fedora 28
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global upname asciitable

%if 0%{?fedora} > 12 || 0%{?rhel} > 6
%global with_python3 1
%else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
%endif

Name: python-module-asciitable
Version: 0.8.0
Release: alt3_22
Summary: Extensible ASCII table reader and writer
License: BSD

Group: Development/Other
URL: http://cxc.harvard.edu/contrib/asciitable/
Source0: http://pypi.python.org/packages/source/a/%{upname}/%{upname}-%{version}.tar.gz
BuildRequires: python-devel python-module-nose
BuildArch: noarch

%global _description\
An extensible ASCII table reader.  Asciitable can read a wide range of ASCII\
table formats via built-in Extension Reader Classes:\
  * Basic: basic table with customizable delimiters and header configurations\
  * Cds: CDS format table (also Vizier and ApJ machine readable tables)\
  * CommentedHeader: column names given in a line that begins with\
  the comment character\
  * Daophot: table from the IRAF DAOphot package\
  * Ipac: IPAC format table\
  * Latex: LaTeX tables (plain and AASTex)\
  * NoHeader: basic table with no header where columns are auto-named\
  * Rdb: tab-separated values with an extra line after the column\
  definition line\
  * Tab: tab-separated values
Source44: import.info

%description 

%_description
%if 0%{?with_python3}
%package -n python3-module-asciitable
Group: Development/Python
Summary: Extensible ASCII table reader and writer
BuildRequires: python3-devel python3-module-nose
Requires: python3-module-numpy python3-module-numpy-testing

%description -n python3-module-asciitable
An extensible ASCII table reader.  Asciitable can read a wide range of ASCII 
table formats via built-in Extension Reader Classes:
  * Basic: basic table with customizable delimiters and header configurations
  * Cds: CDS format table (also Vizier and ApJ machine readable tables)
  * CommentedHeader: column names given in a line that begins with 
  the comment character
  * Daophot: table from the IRAF DAOphot package
  * Ipac: IPAC format table
  * Latex: LaTeX tables (plain and AASTex)
  * NoHeader: basic table with no header where columns are auto-named
  * Rdb: tab-separated values with an extra line after the column 
  definition line
  * Tab: tab-separated values
%endif # with_python3

%prep
%setup -n %{upname}-%{version} -q

%if 0%{?with_python3}
rm -rf %{_builddir}/python3-%{oldname}-%{version}-%{release}
cp -a . %{_builddir}/python3-%{oldname}-%{version}-%{release}
find %{_builddir}/python3-%{oldname}-%{version}-%{release} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif # with_python3

find -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python}|'

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{_builddir}/python3-%{oldname}-%{version}-%{release}
%{__python3} setup.py build
popd
%endif # with_python3

%check
nosetests-%{__python_version}
%if 0%{?with_python3}
pushd %{_builddir}/python3-%{oldname}-%{version}-%{release}
nosetests-%{__python3_version}
popd
%endif # with_python3

%install
%if 0%{?with_python3}
pushd %{_builddir}/python3-%{oldname}-%{version}-%{release}
%{__python3} setup.py install --skip-build --root  %{buildroot}
popd
%endif # with_python3

%{__python} setup.py install --skip-build --root  %{buildroot}
 
%files -n python-module-asciitable
%doc CHANGES doc/index.rst
%{python_sitelibdir_noarch}/*

%if 0%{?with_python3}
%files -n python3-module-asciitable
%doc CHANGES doc/index.rst
%{python3_sitelibdir_noarch}/*
%endif # with_python3


%changelog
