# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
BuildRequires: python-module-setuptools python3-module-setuptools
# END SourceDeps(oneline)
%define oldname python-grapefruit
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if 0%{?fedora}
%global with_python3 1
%endif

%global modname grapefruit

Name:       python-module-grapefruit
Version:    0.1a4
Release:    alt1_10
Summary:    Python module for easy manipulation of color information

Group:      Development/Other
License:    ASL 2.0
URL:        https://github.com/xav/%{modname}
Source0:    https://github.com/xav/Grapefruit/releases/download/%{version}/%{modname}-%{version}.tar.gz
BuildArch:  noarch
BuildRequires:  python-devel

%global _description\
GrapeFruit is a pure python module that let you easily manipulate and convert\
color information. It's primary goal is to be natural and flexible.
Source44: import.info

%description 

%_description
%if 0%{?with_python3}
%package -n python3-module-grapefruit
Summary:        Python module for easy manipulation of color information

Group:          Development/Other
BuildRequires:  python3-devel

%description -n python3-module-grapefruit
GrapeFruit is a pure python module that let you easily manipulate and convert
color information. It's primary goal is to be natural and flexible.

%endif

%prep
%setup -n %{oldname}-%{version} -q -c %{modname}-%{version}
sed -i 's/\r$//' CHANGES LICENSE TODO doc/Makefile doc/index.rst doc/conf.py doc/makedoc.cmd

%if 0%{?with_python3}
rm -rf %{_builddir}/python3-%{oldname}-%{version}-%{release}
cp -a . %{_builddir}/python3-%{oldname}-%{version}-%{release}
# Fix shebang to avoid auto-generating Python 2 dependency in python3- subpackage.
sed -i '1s=^#!/usr/bin/python=#!%{__python3}=' %{_builddir}/python3-%{oldname}-%{version}-%{release}/grapefruit.py
%endif

%build
%python_build

%if 0%{?with_python3}
pushd %{_builddir}/python3-%{oldname}-%{version}-%{release}
%python3_build
popd
%endif

%install
%if 0%{?with_python3}
pushd %{_builddir}/python3-%{oldname}-%{version}-%{release}
%python3_install
chmod a+x $RPM_BUILD_ROOT%{python3_sitelibdir_noarch}/grapefruit.py
popd
%endif

%python_install
chmod a+x $RPM_BUILD_ROOT%{python_sitelibdir_noarch}/grapefruit.py

%check
%{__python} setup.py test
%{__python3} setup.py test

%files -n python-module-grapefruit
%doc --no-dereference LICENSE
%doc doc/ CHANGES COPYING README.rst TODO
%{python_sitelibdir_noarch}/grapefruit-%{version}-py?.?.egg-info
%{python_sitelibdir_noarch}/grapefruit.py*

%if 0%{?with_python3}
%files -n python3-module-grapefruit
%doc --no-dereference LICENSE
%doc doc/ CHANGES COPYING README.rst TODO
%{python3_sitelibdir_noarch}/grapefruit-%{version}-py?.?.egg-info
%{python3_sitelibdir_noarch}/grapefruit.py*
#%{python3_sitelibdir_noarch}/__pycache__/grapefruit*
%endif

%changelog
